/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.frame;

import java.util.Objects;
import lib.toma.animations.IEasing;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.IKeyframe;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;

public class PositionKeyframe
implements IKeyframe {
    private final Vector3d position;
    private final IEasing easing;
    private final float endpoint;
    private Vector3d staticPos = Vector3d.field_186680_a;
    private Vector3d staticRotation = Vector3d.field_186680_a;
    private Quaternion staticRotationQuat = Quaternion.field_227060_a_;
    private Vector3d relativePos = Vector3d.field_186680_a;
    private Vector3d relativeRot = Vector3d.field_186680_a;
    private Quaternion relativeRotQuat = Quaternion.field_227060_a_;

    protected PositionKeyframe(Vector3d position, IEasing easing, float endpoint) {
        this.position = Objects.requireNonNull(position);
        this.easing = easing;
        this.endpoint = endpoint;
        this.calculateRelativePos();
        this.calculateRelativeRot();
    }

    public static IKeyframe positioned(Vector3d position, IEasing easing, float endpoint) {
        return new PositionKeyframe(position, easing, endpoint);
    }

    @Override
    public float endpoint() {
        return this.endpoint;
    }

    @Override
    public Vector3d positionTarget() {
        return this.position;
    }

    @Override
    public Vector3d rotationTarget() {
        return Vector3d.field_186680_a;
    }

    @Override
    public Vector3d initialPosition() {
        return this.staticPos;
    }

    @Override
    public Vector3d initialRotation() {
        return this.staticRotation;
    }

    @Override
    public Vector3d relativePos() {
        return this.relativePos;
    }

    @Override
    public Vector3d relativeRot() {
        return this.relativeRot;
    }

    @Override
    public Quaternion getInitialRotationQuaternion() {
        return this.staticRotationQuat;
    }

    @Override
    public Quaternion getRotationQuaternion() {
        return this.relativeRotQuat;
    }

    @Override
    public IEasing getEasing() {
        return this.easing;
    }

    @Override
    public void baseOn(IKeyframe parent) {
        this.staticPos = Keyframes.getInitialPosition(parent);
        this.staticRotation = Keyframes.getInitialRotation(parent);
        this.staticRotationQuat = Keyframes.rotationVector2Quaternion(this.staticRotation);
        this.calculateRelativePos();
        this.calculateRelativeRot();
    }

    private void calculateRelativePos() {
        this.relativePos = Keyframes.getRelativePosition(this.position, this.staticPos);
    }

    protected void calculateRelativeRot() {
        Vector3d rotation = this.rotationTarget();
        if (rotation == null) {
            return;
        }
        this.relativeRot = Keyframes.getRelativeRotation(rotation, this.staticRotation);
        this.relativeRotQuat = Keyframes.rotationVector2Quaternion(this.relativeRot);
    }
}

